/* -----------------------------------------------------------------------------------------------------------------------------*
 *                   Functionality for "MenulocalizedGermany", "MenulocalizedUSA" and "MenulocalizedJapan"				*
 *									*
 * -----------------------------------------------------------------------------------------------------------------------------*/

var active_button_group; 	// this is the menubutton (with text and icon), that currently has the focus 
var active_b_index = 0;		// the index of the focused button in the array "buttons"
var control_offset = 250; 	// the control-buttons start at this point
var control_space = 100; 	// there is that much space from one control button (middle) to the next
var control_button_y = 520;	// the control buttons are on that height
var c_padding = 5; 		// the space from the control-button edges left and right to the text
var mbutton_padding = 60; 	// the space from the menu-button edges left (and right) to the text
var m_icon_padding = 15;	// the space  from the menu-button edges left to the icon
var mbutton_text_y = -5;	// this value corrects the vertical position of the menu-button text
var topMenu_text_y = -8;	// this value corrects the vertical position of the top-menu text
var control_text_x = 0;		// this value corrects the horizontal position of the control-button text
var control_text_y = 18;	// this value corrects the vertical position of the control-button text
var space = 50;			// menu-buttons are placed in steps of that value
var hor = 50;			// at this horizontal coordinate all menu-buttons are placed
var offset= 130;		// the first menubutton starts vertically at this position
var scrolling = false;		// indicates if scrolling is necessary
var control_texts = new Array();// Array with the text-elements of the MenuButtons
var button_text = new Array(); 	// Array with the text-elements of the control-buttons if available
var buttons = new Array() 	// array that contains the menubutton-groups
var button_icons = new Array() 	// array that contains the menubutton-icons
var started = false; 		// indicates if a mp3 was started
var nrButtons = 0; 		// memorizes the Number of Buttons
var position = 1;		// indicates the position of the active button on the screen
var lowerInvisible = 7;		// This is the index of the first invisible button if the list is too long
var upperInvisible = -1;	// This is the index of the last invisible button if the list is too long
var category_x = 110;
var category_y = 520;

var en = '..\\..\\..\\English\\Phase2Representation\\GUI\\SID_MAINMENU.svg'; 	//the english content is located at this path
var de = '..\\..\\..\\German\\Phase2Representation\\GUI\\SID_MAINMENU.svg'; 	//the german content is located at this path
var ja = '..\\..\\..\\Japanese\\Phase2Representation\\GUI\\SID_MAINMENU.svg'; 	//the japanese content is located at this path

function init()
{

	//Count the elements to determine the number of buttons
	var el =  document.getElementById("MenuButtons").firstChild;
	while(el)
	{
		if(el.getNodeType()==1)nrButtons++;
		el = el.nextSibling;
	}

	if(nrButtons == 8) offset = 95;


	var el = document.getElementById("ScrollUp");
	el.setAttribute("fill","grey");
	el.addEventListener("click", prevMenuPoint, false);
	el = document.getElementById("ScrollDown");
	el.addEventListener("click", nextMenuPoint, false);

	if (nrButtons > 8) 
	{	
		scrolling = true;
	}
	var x = nrButtons;
	document.getElementById("TopMenu").setAttribute("transform", "translate(50,40)");
	var topText = document.getElementById("TopMenu").firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling;
	if(topText){
	var height =  document.getElementById("TopMenu").firstChild.nextSibling.firstChild.nextSibling.getAttribute("height");
	topText.setAttribute("transform","translate("+mbutton_padding+","+(height/2+(topText.getStyle().getPropertyValue("font-size")/2)+topMenu_text_y)+")");
	}
	var button_group = document.getElementById("MenuButtons").firstChild.nextSibling; 
	active_button_group =  button_group;

	for(var i=0; i != x; i++)
	{	
		buttons[i] = button_group;
		var width = button_group.getAttribute("width");
		var height = button_group.getAttribute("height");
	        var button_inactive = button_group.firstChild.nextSibling.firstChild.nextSibling;
		var button_active = button_inactive.nextSibling.nextSibling;
		var text = button_active.nextSibling.nextSibling;
		button_text[i]=text;
		button_icons[i] = text.nextSibling.nextSibling;
		var size = text.getStyle().getPropertyValue("font-size");
			while(text.getComputedTextLength() > width-2*mbutton_padding){
			size--;
			text.getStyle().setProperty("font-size", size);
			}
		var n = offset+(i*space);
		button_group.setAttribute("transform", "translate("+hor+","+n+")");
		if(scrolling){
			if(i>6)
			{
				button_group.setAttribute("style","visibility:hidden");
			}
		}
		button_text[i].setAttribute("transform", "translate("+mbutton_padding+","+(height/2+(button_text[i].getStyle().getPropertyValue("font-size")/2)+mbutton_text_y)+")");
		button_icons[i].setAttribute("transform", "translate("+m_icon_padding+","+(height/2-(button_icons[i].getAttribute("height")/2))+")");
		button_inactive.addEventListener("mouseover", focusin, false);
		button_active.addEventListener("click", universalFunction, false);
		//button_active.addEventListener("mouseout", focusout, false);
		//text.addEventListener("mouseover", textmouseover, false);
		if(button_group.nextSibling.nextSibling)
		{
		button_group = button_group.nextSibling.nextSibling;
		}
	}

	//if this screen has control-buttons, they need to be placed as well
	if(document.getElementById("Controls"))
	{

		x = 0;
		el =  document.getElementById("Controls").firstChild.nextSibling; //first control button group

		//cycle through the control-buttons
		while(el)
		{


			//place button at the right position
			el.setAttribute("transform", "translate("+(control_offset+x*control_space)+","+control_button_y+")");

			//enable button to react to mouseover and mouseout
			el.firstChild.nextSibling.addEventListener("mouseover", highlight, false);
			el.firstChild.nextSibling.nextSibling.nextSibling.addEventListener("mouseout", dehighlight, false);

			//read the buttons width
			var width = el.getAttribute("width");

			//load button-text into the array
			control_texts[x] = el.firstChild.nextSibling.nextSibling.nextSibling.nextSibling.nextSibling;

			//Read out the actual font-size of the button-text to be used while 
			//adapting the font-size if the text is too long 
			var size = control_texts[x].getStyle().getPropertyValue("font-size");

			//We read the length of the text in pixel and look if it fits into the button 
			//with some space to the edges. If not the font-size is adapted till it does
			while(control_texts[x].getComputedTextLength() > width-2*c_padding)
			{
				size--;
				control_texts[x].getStyle().setProperty("font-size", size);
			}

			//correct the position of the text
			control_texts[x].setAttribute("transform", "translate("+(control_text_x+(width/2))+","+control_text_y+")");
			x++; 


			//next Control Button group if there is one
			el = el.nextSibling.nextSibling;
		}
	}

	//place the category-icon at its position
	document.getElementById("category").setAttribute("transform", "translate("+category_x+","+category_y+")");

	//activate the first buttons "focused"-view
	active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:visible");
}
	
/*This is a highlight-function for the control button, called when the mouse is over it. 
*/
function highlight(evt){

	evt.target.setAttribute("style", "visibility:hidden");
	evt.target.nextSibling.nextSibling.setAttribute("style", "visibility:visible");

}
	
/*This is a highlight-function for the control button, called when the mouse is out of it.
*/
function dehighlight(evt){

	evt.target.setAttribute("style", "visibility:hidden");
	evt.target.previousSibling.previousSibling.setAttribute("style", "visibility:visible");
}

function prevMenuPoint(){
	if(active_b_index!=0)
	{		//not the first Button
		if(position!=1){
			position--;
		}	
		else 
		{	
			if(scrolling)

			{ 				

				for(var i=0; i != nrButtons; i++)
				{
					var att = buttons[i].getAttribute('transform');
					var trans ="translate("+att.substring(att.indexOf('(')+1,att.indexOf(','))+","+((att.substring(att.indexOf(',')+1,att.length-1))-(-space))+")";
					buttons[i].setAttribute("transform", trans);
				}

				buttons[upperInvisible].setAttribute("style", "visibility:visible");
				lowerInvisible--;
				buttons[lowerInvisible].setAttribute("style", "visibility:hidden");
				upperInvisible--;

			}
		}

		if(active_b_index==(nrButtons-1))document.getElementById("ScrollDown").setAttribute("fill","black");
		if(active_b_index==1){
			document.getElementById("ScrollUp").setAttribute("fill","grey");
			active_b_index--;
			buttons[active_b_index].firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:visible")
			active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:hidden");
			active_button_group = buttons[active_b_index];
		}
	else {
			active_b_index--;
			buttons[active_b_index].firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:visible")
			active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:hidden");
			active_button_group = buttons[active_b_index];
	}
}
}

function nextMenuPoint(){
	 if(active_b_index!=(nrButtons-1))
	 {									//not the last Button
		if(position!=7){
			position++;
		}	
		else 
		{	
			if(scrolling)
			{ 					
				for(var i=0; i != nrButtons; i++)
				{
					var att = buttons[i].getAttribute('transform');
					buttons[i].setAttribute("transform", "translate("+att.substring(att.indexOf('(')+1,att.indexOf(','))+","+(att.substring(att.indexOf(',')+1,att.length-1)-space)+")");
				}
				buttons[lowerInvisible].setAttribute("style", "visibility:visible");
				lowerInvisible++;
				buttons[upperInvisible+1].setAttribute("style", "visibility:hidden");
				upperInvisible++;
			}
		}
		if(active_b_index==0)document.getElementById("ScrollUp").setAttribute("fill","black");
		if(active_b_index==(nrButtons-2)){
			document.getElementById("ScrollDown").setAttribute("fill","grey");
			active_b_index++;
			buttons[active_b_index].firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:visible")
			active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:hidden");
			active_button_group = buttons[active_b_index];
		}
	else {
			active_b_index++;
			buttons[active_b_index].firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:visible")
			active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:hidden");
			active_button_group = buttons[active_b_index];
	}
}
}

function keys(evt){
	if(evt.getKeyCode()==13){ 			// Enter
		universalFunction();
	}
	if(evt.getKeyCode()==104){ 			// Up on NumPad
		prevMenuPoint();
	}
	if(evt.getKeyCode()==98){ 			// Down on NumPad
		nextMenuPoint();
	}
	if(evt.getKeyCode()==100){ 			// Left on NumPad
			window.history.go(-1);
	}
	if(evt.getKeyCode()==102){ 			// Right on NumPad
		window.history.go(1);
	}
	if(evt.getKeyCode()==80){ 			// "p"
		execute('SID_PLAY');
	}
	if(evt.getKeyCode()==83){ 			// "s"
		execute('SID_STOP');
	}
	if(evt.getKeyCode()==27){ 			// "Esc"
		switchTo('SID_MAINMENU.svg');;
	}
	if(evt.getKeyCode()==77){ 			// "m"
		execute('SID_MUTE');
	}
	if(evt.getKeyCode()==44){ 			// ","
		execute('SID_SEARCH');
	}
	if(evt.getKeyCode()==46){ 			// "."
		window.history.go(-1);
		//document.getElementById("HTML").getAttribute("xlink:href").jukebox.play();
	}
	//alert(evt.getKeyCode());
}

function switchTo(aim){
	window.location.href=aim;
}

function focusin(evt){
	active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:hidden");
	//active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.nextSibling.nextSibling.getStyle().setProperty("font-color", "black");
	evt.target.nextSibling.nextSibling.setAttribute("style", "visibility:visible");
	
	active_button_group = evt.target.parentNode.parentNode;
	var el =  active_button_group;
	var nr = 0;
	while(el)
	{
		if(el.getNodeType()==1)nr++;
		el = el.previousSibling;
	}
	nr--;
	position = position+(nr-active_b_index);
	active_b_index = nr;
	if(active_b_index!=0)document.getElementById("ScrollUp").setAttribute("fill","black");
	if(active_b_index!=nrButtons-1)document.getElementById("ScrollDown").setAttribute("fill","black");
	if(active_b_index==0)document.getElementById("ScrollUp").setAttribute("fill","grey");
	if(active_b_index==nrButtons-1)document.getElementById("ScrollDown").setAttribute("fill","grey");


}

function textmouseover(evt){
evt.target.previousSibling.previousSibling.setAttribute("style", "visibility:visible");
}

/*This function is used by the control buttons for external data like mp3, radio or video. Further functionality has to be implemented here
*/		
function execute(client){
var loc = window.location.href;
var folder = loc.substring(loc.lastIndexOf('/')+1, loc.lastIndexOf('.'));
switch(client){
		case "SID_MUTE":alert('Mute');
		break;
		case "SID_SEARCH": alert('Searching...');
		break;
		case "SID_BACK": window.history.go(-1);
		break;
		case "SID_PLAY": 	if(folder.search(/FOL_.+/)!=-1) //this is a single track in a folder
							{
								var file = active_button_group.getAttribute("sid");
								file = file.substring(4,file.length)+'.mp3';
								switchTo('..\\mp3\\'+folder+'\\'+file);
								started=true;
							}
							else// this is a folder, get the whole playlist
							{
							alert('playing '+ active_button_group.getAttribute("sid"));
							}
		break;
		case "SID_PAUSE": 	if(started)
							{
							alert(active_button_group.getAttribute("sid")+' paused.');
							}
		break;
		case "SID_STOP": 	if(started)
							{
							alert('Cant stop media player. Please stop manually');
							started = false;
							}
		break;
		default: alert('Not implemented yet!');
	}

}

function underConstructionFunction(){
	//does nothing
}

/*This function is used with the menubuttons and decides what to do in which context.
*/
function universalFunction(){
var client = active_button_group.getAttribute("sid");

	if(client.search(/SID.+/)!=-1 || client.search(/FOL.+/)!=-1 ){ //if client a menupoint or folder
		switch(client)
		{
			case "SID_EXIT": alert('Off');
			break;
			case "SID_UC": window.history.go(-1);
			break;
			case "SID_ENGLISH": 	if(window.location.href.search(/LANGUAGE.+/) != -1)underConstructionFunction();
						else switchTo(en);
			break;
			case "SID_GERMAN": 	if(window.location.href.search(/LANGUAGE.+/) != -1)underConstructionFunction();
						else switchTo(de);
			break;
			case "SID_JAPANESE": 	if(window.location.href.search(/LANGUAGE.+/) != -1)underConstructionFunction();
						else switchTo(ja);
			break;
			case "SID_TRAFFICINFO": alert('No News');
			break;		
			case "SID_NAVIGATION":	underConstructionFunction();
			break;	
			case "SID_COMMUNICATION": underConstructionFunction();
			break;	
			case "SID_CLIMATE": underConstructionFunction();
			break;	
			case "SID_INFORMATION": underConstructionFunction();
			break;	
			case "SID_ON": underConstructionFunction();
			break;	
			case "SID_OFF": underConstructionFunction();
			break;	
			case "SID_VOLUME": underConstructionFunction();
			break;	
			case "SID_CONTRAST": underConstructionFunction();
			break;
			case "SID_COLOR": underConstructionFunction();
			break;	
			case "SID_PLAY": underConstructionFunction();
			break;	
			case "SID_STOP": underConstructionFunction();
			break;	
			default: switchTo(client+".svg");
		}
	}
	return false;
}
